<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="{$charset}" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{if $kbarticle.title}{$kbarticle.title} - {/if}{$pagetitle} - {$companyname}</title>
    {include file="$template/includes/head.tpl"}

    {$headoutput}
    <link href="{$WEB_ROOT}/templates/{$template}/css/whost.css" rel="stylesheet">
    <script src="{$WEB_ROOT}/templates/{$template}/js/whost.js"></script>
</head>
<body data-phone-cc-input="{$phoneNumberInputStyle}">

{$headeroutput}

<section id="header">
    <div class="container">
        <div class="row">
            <div class="col-lg-5">
                <div class="header_contact">
                    <a href="">
                       <i class="fa fa-phone small-padding"></i>
                       <span>Phone:</span>+8496221601 
                    </a>
                    <a href="">
                       <i class="fa fa-envelope-o small-padding"></i>
                       someone@example.com
                    </a>
                </div>
            </div>
            <div class="col-lg-7">
                <ul class="top-nav">
                    {if $languagechangeenabled && count($locales) > 1}
                        <li>
                            <a href="#" class="choose-language" data-toggle="popover" id="languageChooser">
                                {$activeLocale.localisedName}
                                <b class="caret"></b>
                            </a>
                            <div id="languageChooserContent" class="hidden">
                                <ul>
                                    {foreach $locales as $locale}
                                        <li>
                                            <a href="{$currentpagelinkback}language={$locale.language}">{$locale.localisedName}</a>
                                        </li>
                                    {/foreach}
                                </ul>
                            </div>
                        </li>
                    {/if}
                    {if $loggedin}
                        <li>
                            <a href="#" data-toggle="popover" id="accountNotifications" data-placement="bottom">
                                {$LANG.notifications}
                                {if count($clientAlerts) > 0}<span class="label label-info">NEW</span>{/if}
                                <b class="caret"></b>
                            </a>
                            <div id="accountNotificationsContent" class="hidden">
                                <ul class="client-alerts">
                                {foreach $clientAlerts as $alert}
                                    <li>
                                        <a href="{$alert->getLink()}">
                                            <i class="fa fa-fw fa-{if $alert->getSeverity() == 'danger'}exclamation-circle{elseif $alert->getSeverity() == 'warning'}warning{elseif $alert->getSeverity() == 'info'}info-circle{else}check-circle{/if}"></i>
                                            <div class="message">{$alert->getMessage()}</div>
                                        </a>
                                    </li>
                                {foreachelse}
                                    <li class="none">
                                        {$LANG.notificationsnone}
                                    </li>
                                {/foreach}
                                </ul>
                            </div>
                        </li>
                        <li class="primary-action">
                            <a href="{$WEB_ROOT}/logout.php" class="btn">
                                {$LANG.clientareanavlogout}
                            </a>
                        </li>
                    {else}
                        <li>
                            <a href="{$WEB_ROOT}/clientarea.php">{$LANG.login}</a>
                        </li>
                        {if $condlinks.allowClientRegistration}
                            <li>
                                <a href="{$WEB_ROOT}/register.php">{$LANG.register}</a>
                            </li>
                        {/if}
                        <li class="primary-action">
                            <a href="{$WEB_ROOT}/cart.php?a=view" class="btn">
                                {$LANG.viewcart}
                            </a>
                        </li>
                    {/if}
                    {if $adminMasqueradingAsClient || $adminLoggedIn}
                        <li>
                            <a href="{$WEB_ROOT}/logout.php?returntoadmin=1" class="btn btn-logged-in-admin" data-toggle="tooltip" data-placement="bottom" title="{if $adminMasqueradingAsClient}{$LANG.adminmasqueradingasclient} {$LANG.logoutandreturntoadminarea}{else}{$LANG.adminloggedin} {$LANG.returntoadminarea}{/if}">
                                <i class="fa fa-sign-out"></i>
                            </a>
                        </li>
                    {/if}
                </ul>
                <ul class="nav navbar-nav navbar-right">
                    {include file="$template/includes/navbar.tpl" navbar=$secondaryNavbar}
                </ul>
            </div>
        </div>
    </div>
</section>

<section id="main-menu">
    <div class="container">
        <div class="row">
            <div class="col-lg-2 col-xs-3">
                {if $assetLogoPath}
                    <a href="{$WEB_ROOT}/index.php" class="logo"><img src="{$assetLogoPath}" alt="{$companyname}"></a>
                {else}
                    <a href="{$WEB_ROOT}/index.php" class="logo logo-text">{$companyname}</a>
                {/if}
            </div>
            <div class="col-lg-10 col-xs-9">
                <nav id="nav" class="navbar navbar-default navbar-main" role="navigation">
                    <!-- Brand and toggle get grouped for better mobile display -->
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#primary-nav">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                    </div>

                    <!-- Collect the nav links, forms, and other content for toggling -->
                    <div class="collapse navbar-collapse" id="primary-nav">
                        <ul class="nav navbar-nav">
                            {include file="$template/includes/navbar.tpl" navbar=$primaryNavbar}
                        </ul>
                    </div><!-- /.navbar-collapse -->
                </nav>
            </div>
        </div>
    </div>
</section>

{if $templatefile == 'homepage'}
    <section id="home-banner" class="domain_register_area whmcs_banner" style="background-image:url('{$WEB_ROOT}/templates/{$template}/img/whmcs-bnr-bg.png');>
        <div class="container text-center">
            <div class="dm_register_heading">
                {if $registerdomainenabled || $transferdomainenabled}
                    <h2>{$LANG.homebegin}</h2>
                    <form method="post" action="domainchecker.php">
                        <div class="domain-search">
                            <div class="input-group input-group-lg">
                                <div class="form-group">
                                    <input type="text" class="form-control" name="domain" placeholder="{$LANG.exampledomain}" autocapitalize="none" />
                                </div>
                                <span class="input-group-btn">
                                    {if $registerdomainenabled}
                                        <input type="submit" class="btn search" value="{$LANG.search}" />
                                    {/if}
                                    {if $transferdomainenabled}
                                        <input type="submit" name="transfer" class="btn transfer" value="{$LANG.domainstransfer}" />
                                    {/if}
                                </span>
                                <div class="domain_name_list">
                                    <ul>
                                        <li class="com">.com</li>
                                        <li class="net">.net</li>
                                        <li class="org">.org</li>
                                        <li class="me">.me</li>
                                        <li class="edu">.edu</li>
                                        <li class="shop">.shop</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        {include file="$template/includes/captcha.tpl"}
                    </form>
                {else}
                    <h2>{$LANG.doToday}</h2>
                {/if}
                <div class="captcha_area">
                    <a href="http://themeim.com/demo/whosting/">
                        <i class="fa fa-arrow-left"></i>
                        <span>Back Home</span>
                    </a>
                </div>
            </div>
        </div>
    </section>
    
    <!-- ========== Start Pricing Area ============= -->
    <section class="pricing_area">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-sm-6">
                    <div class="single_price">
                        <div class="pricing_title">
                            <h3>Vps Hosting</h3>
                        </div>
                        <div class="sn_price_border">
                            <div class="pricing_currency">
                                <h2><sup>$</sup>180<span>.00</span></h2>
                                <span>
                                    per year
                                </span>
                            </div>
                            <div class="pricing_list">
                                <ul>
                                    <li>
                                        <a href="">Unlimited Storage</a>
                                    </li>
                                    <li>
                                        <a href="">Free Domain Register</a>
                                    </li>
                                    <li>
                                        <a href="">70FB Bandwidth</a>
                                    </li>
                                    <li>
                                        <a href="">Free Cpanel</a>
                                    </li>
                                    <li>
                                        <a href="">24/7 instant Suport</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="pricing_btn">
                                <a href="" class="btn_two">Get Started  <i class="fa fa-angle-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="single_price">
                        <div class="pricing_title">
                            <h3>Cloud Hosting</h3>
                        </div>
                        <div class="sn_price_border">
                            <div class="pricing_currency">
                                <h2><sup>$</sup>180<span>.00</span></h2>
                                <span>
                                    per year
                                </span>
                            </div>
                            <div class="pricing_list">
                                <ul>
                                    <li>
                                        <a href="">Unlimited Storage</a>
                                    </li>
                                    <li>
                                        <a href="">Free Domain Register</a>
                                    </li>
                                    <li>
                                        <a href="">70FB Bandwidth</a>
                                    </li>
                                    <li>
                                        <a href="">Free Cpanel</a>
                                    </li>
                                    <li>
                                        <a href="">24/7 instant Suport</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="pricing_btn">
                                <a href="" class="btn_two">Get Started  <i class="fa fa-angle-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="single_price">
                        <div class="pricing_title">
                            <h3>Shared Hosting</h3>
                        </div>
                        <div class="sn_price_border">
                            <div class="pricing_currency">
                                <h2><sup>$</sup>180<span>.00</span></h2>
                                <span>
                                    per year
                                </span>
                            </div>
                            <div class="pricing_list">
                                <ul>
                                    <li>
                                        <a href="">Unlimited Storage</a>
                                    </li>
                                    <li>
                                        <a href="">Free Domain Register</a>
                                    </li>
                                    <li>
                                        <a href="">70FB Bandwidth</a>
                                    </li>
                                    <li>
                                        <a href="">Free Cpanel</a>
                                    </li>
                                    <li>
                                        <a href="">24/7 instant Suport</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="pricing_btn">
                                <a href="" class="btn_two">Get Started  <i class="fa fa-angle-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ========== End Pricing Area ============= -->

    <!-- ========== Domain Promo Area Two============= -->
    <section class="domain_promo_area_two">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <div class="hw_can_help">
                        <h2>{$LANG.howcanwehelp}</h2>
                        <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse Cillumporro quisqua.</p>
                        <div class="hw_can_help_list">
                            <ul>
                                <li>
                                    <i class="fa fa-check" aria-hidden="true"></i>
                                    dolor in reprehenderit in voluptate velit esse cillumporro quisqua.
                               </li>
                                <li>
                                    <i class="fa fa-check" aria-hidden="true"></i>
                                    dolor in reprehenderit in voluptate velit esse cill.
                               </li>
                                <li>
                                    <i class="fa fa-check" aria-hidden="true"></i>
                                    dolor in reprehenderit in volupta.
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="domain_promo_asked">
                        <ul>
                            {if $registerdomainenabled || $transferdomainenabled}
                                <li class="single_asked">
                                    <i class="fa fa-globe"></i>
                                    <h3>{$LANG.buyadomain}</h3>
                                    <a href="domainchecker.php">Get Started <i class="fa fa-angle-right"></i></a>
                                </li>
                            {/if}
                            <li class="single_asked">
                                <i class="fa fa-hdd-o"></i>
                                <h3>{$LANG.orderhosting}</h3>
                                <a href="cart.php">Get Started <i class="fa fa-angle-right"></i></a>
                            </li>
                            <li class="single_asked">
                                <i class="fa fa-credit-card"></i>
                                <h3>{$LANG.makepayment}</h3>
                                <a href="clientarea.php">Get Started <i class="fa fa-angle-right"></i></a>
                            </li>
                            <li class="single_asked">
                                <i class="fa fa-envelope-o"></i>
                                <h3>{$LANG.getsupport}</h3>
                                <a href="submitticket.php">Get Started <i class="fa fa-angle-right"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ========== Domain Promo Area Two ============= -->
    
    <!-- ========== Start Hoster Module Area ============= -->
    <section class="hoster_module_area">
        <div class="hstr_mdle_bg">
            <img src="{$WEB_ROOT}/templates/{$template}/img/hoster-module-bg.png" alt="">
            <a href="https://www.youtube.com/watch?v=z0xoDhg8qsg" class="video_play">
                <i class="fa fa-play-circle"></i>
            </a>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-lg-offset-6 col-sm-12 col-md-6 col-md-offset-6">
                    <div class="hstr_mdle_content"> 
                        <h4>Hoster's modular design</h4>
                        <h3>Makes site building easy</h3>
                        <div class="hstr_mdle_list">
                            <p>Hoster is a remarkably flexible and feature-complete HTML template built for modern startups, creatives, bloggers and more. Including tons of uniquely.</p>
                            <ul>
                               <li>
                                   <i class="fa fa-check-circle-o" aria-hidden="true"></i>
                                   Unlimited Web Space & Data
                               </li>
                               <li>
                                   <i class="fa fa-check-circle-o" aria-hidden="true"></i>
                                   Free Domain Name
                               </li>
                               <li>
                                   <i class="fa fa-check-circle-o" aria-hidden="true"></i>
                                   cPanel Control Panel
                               </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ========== End  Hoster Module Area ============= -->
{/if}

{include file="$template/includes/verifyemail.tpl"}

<section id="main-body">
    <div class="container{if $skipMainBodyContainer}-fluid without-padding{/if}">
        <div class="row">
            <div class="whmch_whost_partner_slider">
                <div class="single_whmch_partner">
                    <a href="">
                        <img src="{$WEB_ROOT}/templates/{$template}/img/whmch-whost-one.png" alt="">
                    </a>
                </div>
                <div class="single_whmch_partner">
                    <a href="">
                        <img src="{$WEB_ROOT}/templates/{$template}/img/whmch-whost-two.png" alt="">
                    </a>
                </div>
                <div class="single_whmch_partner">
                    <a href="">
                        <img src="{$WEB_ROOT}/templates/{$template}/img/whmch-whost-three.png" alt="">
                    </a>
                </div>
                <div class="single_whmch_partner">
                    <a href="">
                        <img src="{$WEB_ROOT}/templates/{$template}/img/whmch-whost-four.png" alt="">
                    </a>
                </div>
            </div> 

        {if !$inShoppingCart && ($primarySidebar->hasChildren() || $secondarySidebar->hasChildren())}
            {if $primarySidebar->hasChildren() && !$skipMainBodyContainer}
                <div class="col-md-9 pull-md-right">
                    {include file="$template/includes/pageheader.tpl" title=$displayTitle desc=$tagline showbreadcrumb=true}
                </div>
            {/if}
            <div class="col-md-3 pull-md-left sidebar">
                {include file="$template/includes/sidebar.tpl" sidebar=$primarySidebar}
            </div>
        {/if}
        <!-- Container for main page display content -->
        <div class="{if !$inShoppingCart && ($primarySidebar->hasChildren() || $secondarySidebar->hasChildren())}col-md-9 pull-md-right{else}col-xs-12{/if} main-content">
            {if !$primarySidebar->hasChildren() && !$showingLoginPage && !$inShoppingCart && $templatefile != 'homepage' && !$skipMainBodyContainer}
                {include file="$template/includes/pageheader.tpl" title=$displayTitle desc=$tagline showbreadcrumb=true}
            {/if}
